<?php
include 'connection.php';

require __DIR__ . '/vendor/autoload.php';

ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);


// if (php_sapi_name() != 'cli') {
//     throw new Exception('This application must be run on the command line.');
// }

use Google\Client;
use Google\Service\Gmail;

/**
 * Returns an authorized API client.
 * @return Client the authorized client object
 */
function getClient()
{
    $client = new Client();
    $client->setApplicationName('Gmail API PHP Quickstart');
    $client->setScopes('https://mail.google.com');
    $client->setAuthConfig('credentials.json');
    $client->setAccessType('offline');
    $client->setPrompt('select_account consent');

    // Load previously authorized token from a file, if it exists.
    // The file token.json stores the user's access and refresh tokens, and is
    // created automatically when the authorization flow completes for the first
    // time.
    $tokenPath = 'token.json';
    if (file_exists($tokenPath)) {
        $accessToken = json_decode(file_get_contents($tokenPath), true);
        $client->setAccessToken($accessToken);
    }

    // If there is no previous token or it's expired.
    if ($client->isAccessTokenExpired()) {
        // Refresh the token if possible, else fetch a new one.
        if ($client->getRefreshToken()) {
            $client->fetchAccessTokenWithRefreshToken($client->getRefreshToken());
        } else {
            // Request authorization from the user.
            $authUrl = $client->createAuthUrl();
            printf("Open the following link in your browser:\n%s\n", $authUrl);
            print 'Enter verification code: ';
            $authCode = trim(fgets(STDIN));

            // Exchange authorization code for an access token.
            $accessToken = $client->fetchAccessTokenWithAuthCode($authCode);
            $client->setAccessToken($accessToken);

            // Check to see if there was an error.
            if (array_key_exists('error', $accessToken)) {
                throw new Exception(join(', ', $accessToken));
            }
        }
        // Save the token to a file.
        if (!file_exists(dirname($tokenPath))) {
            mkdir(dirname($tokenPath), 0700, true);
        }
        file_put_contents($tokenPath, json_encode($client->getAccessToken()));
    }
    return $client;
}


// Get the API client and construct the service object.
$client = getClient();
$service = new Gmail($client);


$unused_label = ["CHAT","SENT","TRASH","DRAFT","UNREAD"];
$label_ids = ["SENT"];
// try{

//     // Print the labels in the user's account.
//     $user = 'me';
//     $results = $service->users_labels->listUsersLabels($user);

//     if (count($results->getLabels()) == 0) {
//     } else {
//         foreach ($results->getLabels() as $label) {
//             if (!in_array($label->id, $unused_label))
//             {
//                 $label_ids[] = $label->id;
//             }
//         }
//     }
// }
// catch(Exception $e) {
//     // TODO(developer) - handle error appropriately
//     echo 'Message: ' .$e->getMessage();
// }
$updates_emails = [];
$next_page_token = "";
$a = 1;
try{
    for($i = 0 ; $i < 3 ; $i++){
        $optParams = [];
        $optParams['maxResults'] = 100; // Return Only 100 Messages
        $optParams['labelIds'] = $label_ids; // Only show messages in Inbox
        if(!empty($next_page_token)){
            $optParams['pageToken'] = $next_page_token;
        }
        $messages = $service->users_messages->listUsersMessages('me',$optParams);
        $next_page_token = $messages->getNextPageToken();
    
        $list = $messages->getMessages();
        foreach($list as $key => $value){
            $messageId = $value->getId(); // Grab first Message
            
            $optParamsGet = [];
            $optParamsGet['format'] = 'full'; // Display message in payload
            $message = $service->users_messages->get('me',$messageId,$optParamsGet);
    
            $messagePayload = $message->getPayload();
            
            $headers = $message->getPayload()->getHeaders();
            $email = "";
            $date = "";
            foreach($headers as $k => $v){
                if($v->name == "To"){
                    $email = str_replace(["'",'"'],"",$v->value);
                    $sql_check_email_exists = "SELECT * FROM `bbqpo_customers` WHERE customer_email = '$email'";
                    $checkEmail = mysqli_query($connect,$sql_check_email_exists);
                    $rowcount=mysqli_num_rows($checkEmail);
                    if($rowcount == 0){
                        $pattern = "/\<(.+)\>/i";
                        preg_match($pattern, $email, $list);
    
                        if(count($list) != 0){
                            $email = $list[1];
                        }
                    }
                    echo $a++." ".$email."<br>";
                }
                elseif($v->name == "Date"){
                    $date = date('Y-m-d H:i:s', strtotime($v->value));
                }
            }    
            
            $flag_updated = 1;
            if(!empty($date) && !empty($email) && !in_array($email,$updates_emails)){
                $sql_check_email_exists = "SELECT * FROM `bbqpo_customers` WHERE customer_email = '$email'";
                $checkEmail = mysqli_query($connect,$sql_check_email_exists);
                $old_record = mysqli_fetch_assoc($checkEmail);
                $rowcount = mysqli_num_rows($checkEmail);
                if($old_record && !empty($old_record["last_bbq_interaction_date"])){
                    $old_date = strtotime($old_record["last_bbq_interaction_date"]);
                    $new_date = strtotime($date);
                    if($old_date >= $new_date){
                        $flag_updated = 0;
                    }
                    else{
                        $flag_updated = 1;
                    }
                }
                if($rowcount != 0 && $flag_updated == 1){
                    echo $sql_update_customer_contact_us = "UPDATE `bbqpo_customers` SET last_bbq_interaction_date='$date' WHERE customer_email = '$email'";
                    echo "<br>";
                    if(mysqli_query($connect,$sql_update_customer_contact_us)){
                        echo "UPDATE SUCCESS"."<br>";
                      $updates_emails[] = $email;
                    }             
                }
            }
        }        
    }

}
catch(Exception $e) {
    // TODO(developer) - handle error appropriately
    echo 'Message: ' .$e->getMessage();
}

?>