<?php
include '../configuration.php';

$nameDB = "bbqpel5_cabbqsupply_bbqpelle_db2016";
$connect = mysqli_connect($servernameDB, $usernameDB, $passwordDB, $nameDB);

if (!$connect) {
    die("Connection failed: " . mysqli_connect_error());
}

/**
 * Safe escaping
 */
function esc($conn, $value) {
    return mysqli_real_escape_string($conn, trim($value));
}

/**
 * Error mailer
 */
function send_mail($msg) {
    $subject = "Cron orders to tracing";
    $headers = "From: quotes@bbqpelletsonline.com";
    $to      = "bbqpelletsonline@gmail.com";
    mail($to, $subject, $msg, $headers);
}

/**
 * --- STEP 1 ---
 * Sync orders into trace_shipments
 */
$orders = mysqli_query(
    $connect,
    "SELECT * 
     FROM orders 
     WHERE (tracking != '' OR pickup_number != '' OR from_type='Vendor Shipping')
       AND `created_at` >= LAST_DAY(NOW()) + INTERVAL 1 DAY - INTERVAL 3 MONTH
     ORDER BY id DESC"
);

while ($this_order = mysqli_fetch_assoc($orders)) {

    // Normalize from_type
    if ($this_order['from_type'] == "BBQ") {
        $this_order['from_type'] = "LJ";
    }

    // Escape values
    foreach ($this_order as &$v) {
        $v = esc($connect, $v);
    }

    // Check if trace already exists
    $executeTrace = mysqli_query($connect, "SELECT * FROM trace_shipments WHERE order_id = '{$this_order['id']}'");
    $numRows = mysqli_num_rows($executeTrace);
    $check   = mysqli_fetch_assoc($executeTrace);

    if ($numRows == 0) {
        // Insert new trace record
        $date = date("Y-m-d");

        $q = "INSERT INTO trace_shipments 
                (date, pickup_num, bolpro_num, archive, consignee, updated_date, type,
                 shipper, deliveryStatus, deliveryDate, pickup_terminal, price, notified, check_update,
                 appt, customer_name, shipper_date, shipping_price, user_edit, note, ship_status,
                 shipper_notes, shipped_date, order_id, get_from, carage_agent, call_ahead,
                 delivery_type, unload_type)
              VALUES (
                '{$date}', '{$this_order['pickup_number']}', '{$this_order['tracking']}', '0',
                '{$this_order['firstname']} {$this_order['lastname']} / {$this_order['company']}',
                '{$this_order['updated_at']}', '{$this_order['from_type']}',
                '{$this_order['shipper']}', '{$this_order['deliveryStatus']}',
                '{$this_order['deliveryDate']}', 0, '{$this_order['shippingprice']}', 0, 0,
                '{$this_order['appointmet']}', '{$this_order['customer']}',
                '{$this_order['ship_date']}', '{$this_order['shippingprice']}', 0,
                '{$this_order['order_notes']}', '{$this_order['shipping_status']}','',
                '{$this_order['ship_date']}', '{$this_order['id']}','cron-orders-tracing.php',
                '{$this_order["carage_agent"]}','{$this_order["call_ahead"]}',
                '{$this_order['locationtype']}', '{$this_order['hand_unload']}'
              )";

        if (!mysqli_query($connect, $q)) {
            send_mail(mysqli_error($connect));
        }

    } else {
        // Update existing trace
        $tracking = "";
        if (!empty($this_order['tracking']) && empty($check["bolpro_num"])) {
            $tracking = "`bolpro_num`='{$this_order['tracking']}',";
        }

        $pickup_number = "`pickup_num`='{$this_order['pickup_number']}',";

        $q = "UPDATE trace_shipments 
              SET $pickup_number $tracking 
                  consignee='{$this_order['firstname']} {$this_order['lastname']} / {$this_order['company']}',
                  carage_agent='{$this_order['carage_agent']}',
                  delivery_type='{$this_order['locationtype']}',
                  unload_type='{$this_order['hand_unload']}',
                  type='{$this_order['from_type']}',
                  shipper='{$this_order['shipper']}',
                  appt='{$this_order['appointmet']}',
                  call_ahead='{$this_order['call_ahead']}',
                  customer_name='{$this_order['customer']}',
                  shipper_date='{$this_order['ship_date']}',
                  ship_status='{$this_order['shipping_status']}',
                  shipped_date='{$this_order['ship_date']}',
                  order_id='{$this_order['id']}'
              WHERE order_id='{$this_order['id']}'";

        if (!mysqli_query($connect, $q)) {
            send_mail(mysqli_error($connect));
        }
    }
}

/**
 * --- STEP 2 ---
 * Sync trace_shipments back into orders
 */
$sql = "SELECT * FROM `trace_shipments` 
        WHERE `pickup_num` <> '' 
          AND archive=0 
          AND deliveryStatus NOT IN ('Delivered', 'Delivered.')";

$execute = mysqli_query($connect, $sql);

while ($row = mysqli_fetch_assoc($execute)) {
    $deliveryStatus = $row["deliveryStatus"];
    $shipped_date   = $row["shipped_date"];
    $ship_status    = $row["ship_status"];
    $bolpro_num     = $row["bolpro_num"];

    if ($bolpro_num != "") {
        $shippedFlag    = "";
        $trackingUpdate = "";

        if (!empty($deliveryStatus)) {
            $shippedFlag = ", `shipped`='Shipped'";
        }

        $sql_get_order = "SELECT * FROM orders WHERE id=" . intval($row["order_id"]);
        $execute_get_order = mysqli_query($connect, $sql_get_order);
        if (!$execute_get_order) {
            echo "Error executing query: " . mysqli_error($connect) . "\n";
            continue;
        }

        $order = mysqli_fetch_assoc($execute_get_order);

        // Ensure tracking is not duplicated
        $tracking_check = mysqli_query(
            $connect,
            "SELECT * FROM orders WHERE tracking = '{$order['tracking']}'"
        );
        if (mysqli_num_rows($tracking_check) == 0 && empty($order["tracking"])) {
            $trackingUpdate = ", `tracking`='$bolpro_num'";
        }

        // Archive invoices if already shipped
        if ($order['shipped'] == 'Shipped') {
            $sql_update_invoice_archive =
                "UPDATE invoices SET `archive`=1 WHERE order_id='{$row["order_id"]}'";
            mysqli_query($connect, $sql_update_invoice_archive);
        }

        // Final update
        $sql_update = "UPDATE orders 
                       SET `ship_date`='$shipped_date',
                           `deliveryStatus`='$deliveryStatus', 
                           `ship_status`='$ship_status'
                           $shippedFlag $trackingUpdate
                       WHERE id='{$row["order_id"]}'";

        echo $sql_update . "\n";
        mysqli_query($connect, $sql_update);
    }
}

// Close connection
mysqli_close($connect);
