<?php
include '../configuration.php';

$nameDB = "bbqpel5_cabbqsupply_bbqpelle_db2016";

$connect = mysqli_connect($servernameDB,$usernameDB,$passwordDB,$nameDB);

$orders  = mysqli_query($connect, "SELECT * FROM `orders` WHERE archive=0 AND `created_at` >= last_day(now()) + interval 1 day - interval 2 month ORDER BY id DESC");

$shipped  = mysqli_query($connect, "SELECT * FROM `central_api` WHERE `created_at` >= last_day(now()) + interval 1 day - interval 1 month ORDER BY id DESC");

$trace_shipments  = mysqli_query($connect, "SELECT * FROM `trace_shipments` WHERE `date` >= last_day(now()) + interval 1 day - interval 1 month ORDER BY ID DESC");

$orders_list = [];
$lat_long_orders = [];
$orders_list_tracking_number = [];
$orders_list_pickup_number = [];

$shipped_list = [];
$lat_long_shipped = [];

$trace_shipments_list = [];
$pickup_numbers = [];

while($row = mysqli_fetch_assoc($orders)){
    $orders_list[] = $row;
    $orders_list_tracking_number[$row["tracking"]] = $row;
    $orders_list_pickup_number[$row["pickup_number"]] = $row;
    $lat_long_orders[$row["latitude"]."@".$row["longitude"]] = $row;
}

while($row = mysqli_fetch_assoc($shipped)){
    $shipped_list[] = $row;
    $lat_long_shipped[$row["latitude"]."@".$row["longitude"]] = $row;
}

while($row = mysqli_fetch_assoc($trace_shipments)){
    $trace_shipments_list[] = $row;
    $pickup_numbers[$row["pickup_num"]] = $row;
}

foreach($orders_list as $key => $row){

    if(empty($row["latitude"]) || $row["latitude"] == null){
        update_lat_long_order($connect,$row);
    }
    if(empty($row["longitude"]) || $row["longitude"] == null){
        update_lat_long_order($connect,$row);
    }
    if(strtolower($row["shipped"]) == "unshipped"){

        update_shipped($connect,$row,$shipped_list,$orders_list_tracking_number,$orders_list_pickup_number, $pickup_numbers);
        
    }
    
    if(strtolower($row["shipped"]) == "shipped" && strtolower($row["shipper"]) == "ctl2" && empty($row["tracking"])){
        update_shipped($connect,$row,$shipped_list,$orders_list_tracking_number,$orders_list_pickup_number, $pickup_numbers);
    }

}

foreach($shipped as $key => $row){
    if(empty($row["latitude"]) || $row["latitude"] == null){
        update_lat_long_shipped($connect,$row);
    }
    if(empty($row["longitude"]) || $row["longitude"] == null){
        update_lat_long_shipped($connect,$row);
    }
}
// Close the MySQL connection
mysqli_close($connect);
function update_shipped($connect, $row, $shipped_list,$orders_list_tracking_number,$orders_list_pickup_number, $pickup_numbers){

    foreach($shipped_list as $key => $value){

    if(empty($value["longitude"]) || empty($row["longitude"]) || empty($value["latitude"]) || empty($row["latitude"])){
        continue;    
    }
    $flag_ctl2 = false;

    if($value["global_shipper"] == "CTL2"){
        if(isset($pickup_numbers[$tracking])){
            if(empty($pickup_numbers[$tracking]["bolpro_num"])){
            // if(stripos($pickup_numbers[$tracking]["deliveryStatus"],"Contact Customer") !== FALSE){
                $flag_ctl2 = true;
            // }                
            }

        }
        elseif(isset($pickup_numbers[$pickup_number])){
            if(empty($pickup_numbers[$tracking]["bolpro_num"])){
                // if(stripos($pickup_numbers[$pickup_number]["deliveryStatus"],"Contact Customer") !== FALSE){
                    $flag_ctl2 = true;
                // }
            }
        }
    }

    // && ($value["global_shipper"] != "CTL2")
    if(($value["longitude"] == $row["longitude"]) && ($value["latitude"] == $row["latitude"]) && (($value["is_shipped"] == 0) || $flag_ctl2)){
        $central_id = $value["id"];
        $tracking = $value["pro_number"];
        $pickup_number = $value["bol_number"];

    
        if(isset($orders_list_tracking_number[$tracking])){
        }
        elseif(isset($orders_list_pickup_number[$pickup_number])){
        }
        else{
            $order_company = trim(strtolower($row["company"]));
            $shipped_company = trim(strtolower($value["consignee"]));
            
            if((stripos($order_company,"pickup at") === false) && (stripos($order_company,"treasures") === false) && (stripos($order_company,"Innovations") === false) && (stripos($shipped_company,"Innovations") === false) && (stripos($shipped_company,"pickup at") === false) && (stripos($shipped_company,"treasures") === false)){
                if($value["compare_with_order"] == 1){
                    
                }
                else{
                    update_field($connect, "central_api", "is_shipped", 1, $central_id);
                    update_field($connect, "central_api", "compare_with_order", 1, $central_id);
                    update_field($connect, "orders", "tracking", $tracking, $row["id"]);
                    if(empty($row["pickup_number"])){
                        update_field($connect, "orders", "pickup_number", $tracking, $row["id"]);                    
                    }
                    update_field($connect, "central_api", "mapped_date", date("Y-m-d H:i:s"), $central_id);
                }
            }

        }
    }
}

    
}

function update_lat_long_shipped($connect,$row){
    // $order_address = $row['consignee_address'] . ' ' . $row['consignee_city'] . ' ' . $row['consignee_state'] . ' US';
    $order_address = $row['consignee_zipcode'];
    $address_info = get_lat_long($order_address);
    $lat = "";
    $lng = "";

    if($address_info["data"][0]["latitude"] && !empty($address_info["data"][0]["latitude"])){
        $lat = $address_info["data"][0]["latitude"];
        update_field($connect, "central_api", "latitude", $lat, $row["id"]);
    }
    
    if($address_info["data"][0]["longitude"] && !empty($address_info["data"][0]["longitude"])){
        $lng = $address_info["data"][0]["longitude"];
        update_field($connect, "central_api", "longitude", $lng, $row["id"]);
    }   
}

function update_lat_long_order($connect,$row){
    // $order_address = $row['address_del'] . ' ' . $row['city'] . ' ' . $row['state'] . ' US';
    $order_address = $row["zip_del"];
    $address_info = get_lat_long($order_address);
    $lat = "";
    $lng = "";
    
    if($address_info["data"][0]["latitude"] && !empty($address_info["data"][0]["latitude"])){
        $lat = $address_info["data"][0]["latitude"];
        $row["latitude"] = $lat;
        update_field($connect, "orders", "latitude", $lat, $row["id"]);
    }
    
    if($address_info["data"][0]["longitude"] && !empty($address_info["data"][0]["longitude"])){
        $lng = $address_info["data"][0]["longitude"];
        $row["longitude"] = $lng;
        update_field($connect, "orders", "longitude", $lng, $row["id"]);
    }
}

// echo "test";
function get_lat_long($address){
    
    $keys = [
        1 => "f90d7c9f2065a37651cfabb8acacb719",
        2 => "0c382987776487d424731316640c5f35",
        3 => "8bce503581104ece581b197bf05b82a6",
        4 => "f2c11a49ae06f68f3361fd2b90803f89",
        5 => "c33982fa75c700e5ff672a5c7b37021e",
        6 => "111c915eb9d8b3fed0f925e7b7cd712c",
        7 => "6440f7490f41e7def27445bb9b83eeab",
        8 => "26359ecae926cd40d8deced6adcc16ca"
    ];
    $random = rand(1,8);
    $queryString = http_build_query([
    'access_key' => $keys[$random], //0c382987776487d424731316640c5f35
    // 'query' => $res['address_line_1'] . ' ' . $res['address_city'] . ' ' . $res['address_state'] . ' US',
    'query' => $address,
    //  'region' => $res['address_state'],
    'output' => 'json',
    'limit' => 1,
    ]);
    $url = sprintf('%s?%s', 'http://api.positionstack.com/v1/forward', $queryString);
    //call api
    $json = url_get_contents($url);
    $json = json_decode($json,1);
    return $json;
}

function url_get_contents ($Url) {
    if (!function_exists('curl_init')){ 
        die('CURL is not installed!');
    }
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $Url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    $output = curl_exec($ch);
    curl_close($ch);
    return $output;
}

function update_field($connect, $table_name, $column_name, $value, $id){
    echo $update_sql = "UPDATE `$table_name` SET `$column_name`='$value' WHERE id=".$id;
    echo"<br>";
    if(mysqli_query($connect, $update_sql)){
        echo "order :".$id."<br>"; 
    }
    else{
        echo "Order not updated"."<br>";
    }
}
?>