<?php
/**
 * @package     BreezingForms
 * @author      Markus Bopp
 * @link        http://www.crosstec.de
 * @license     GNU/GPL
*/

// TODO: uninstall routine

// no direct access
defined( '_JEXEC' ) or die( 'Restricted access' );

if(!defined('DS')){
    define('DS', DIRECTORY_SEPARATOR);
}

jimport( 'joomla.plugin.plugin' );
jimport('joomla.version');
               
class plgBreezingforms_addonsZapier extends JPlugin
{
    
    function __construct( &$subject, $params )
    {
        parent::__construct($subject, $params);
    
        $lang = JFactory::getLanguage();
        $lang->load('plg_breezingforms_addons_zapier', JPATH_ADMINISTRATOR);
        
        $db = JFactory::getDBO();
        
        $tables = $db->getTableList();
        
        if( !in_array( $db->getPrefix().'breezingforms_addons_zapier', $tables ) ){
            $db->setQuery("CREATE TABLE `#__breezingforms_addons_zapier` (
                `id` int(11) NOT NULL,
                `form_id` int(11) NOT NULL DEFAULT '0',
                `enabled` tinyint(1) NOT NULL DEFAULT '0',
                `head_data` tinyint(1) NOT NULL DEFAULT '0',
                `exclude_fields` text NOT NULL,
                `attach_pdf` tinyint(1) NOT NULL DEFAULT '0',
                `attach_csv` tinyint(1) NOT NULL DEFAULT '0',
                `attach_xml` tinyint(1) NOT NULL DEFAULT '0',
                `webhooks`  text
              ) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=utf8");
            $db->execute();
            
            $db->setQuery("ALTER TABLE `#__breezingforms_addons_zapier`
              ADD PRIMARY KEY (`id`),
              ADD UNIQUE KEY `form_id_2` (`form_id`)");
            $db->execute();
            
            $db->setQuery("ALTER TABLE `#__breezingforms_addons_zapier`
                MODIFY `id` int(11) NOT NULL AUTO_INCREMENT,AUTO_INCREMENT=1");
            $db->execute();
        }
        
        
        jimport('joomla.filesystem.file');
	    jimport('joomla.filesystem.folder');
    }
    
    function onPropertiesDisplay($form_id, $tabs){
        
        if(!$form_id) return '';
        
        $error = '';
        
        $db = JFactory::getDBO();
        
        $db->setQuery("Select * From #__breezingforms_addons_zapier Where form_id = " . intval($form_id));
        $tg = $db->loadObject();
        
        $me = array();
        
        if( $tg === null ){
            $tg = new stdClass();
            $tg->id = 0;
            $tg->form_id = 0;
            $tg->head_data = 0;
            $tg->enabled = 0;
            $tg->exclude_fields = '';
            $tg->attach_pdf = 0;
            $tg->attach_csv = 0;
            $tg->attach_xml = 0;
	        $tg->webhooks = '';

        }

        ob_start();
        $version = new JVersion();
        require_once JPATH_SITE . DS . 'plugins' . DS . 'breezingforms_addons' . DS . 'zapier' . DS . 'breezingforms_addons_zapier_tmpl' . DS . 'properties.php';
	    $c = ob_get_contents();
        ob_end_clean();
        return $c;

    }
    
    function onPropertiesSave($form_id){
        
        if(!$form_id) return '';
        
        $reset_accessToken = false;

        if(isset($_POST['zapier_reset'])){
            $reset_accessToken = true;
        }
        
        $db = JFactory::getDBO();

	    if( $reset_accessToken ){


		    $db->setQuery("Delete From #__breezingforms_addons_zapier Where form_id = " . intval($form_id));
		    $db->execute();
	    }
	    else {

		    $db->setQuery( "Select form_id From #__breezingforms_addons_zapier Where form_id = " . intval( $form_id ) );
		    $exists = $db->loadResult();

		    if ( ! $exists ) {
			    $db->setQuery( "Insert Into #__breezingforms_addons_zapier (
                `form_id`, `enabled`,`head_data`,`exclude_fields`,`attach_pdf`,`attach_csv`,`attach_xml`,`webhooks` ) Values 
                (   " . intval( $form_id ) . ",
                    " . JRequest::getInt( 'zapier_enabled', 0 ) . ",
                    " . JRequest::getInt( 'zapier_head_data', 0 ) . ",
                    " . $db->quote( JRequest::getVar( 'zapier_exclude_fields', '' ) ) . ",
                    " . JRequest::getInt( 'zapier_attach_pdf', 0 ) . ",
                    " . JRequest::getInt( 'zapier_attach_csv', 0 ) . ",
                    " . JRequest::getInt( 'zapier_attach_xml', 0 ) . ",
                    " . $db->quote( JRequest::getVar( 'zapier_webhooks', '' ) ) . "
                )" );
			    $db->execute();
		    } else {
			    $db->setQuery( "Update #__breezingforms_addons_zapier Set
                `enabled`  = " . JRequest::getInt( 'zapier_enabled', 0 ) . ",
                `head_data`  = " . JRequest::getInt( 'zapier_head_data', 0 ) . ",
                `attach_pdf`  = " . JRequest::getInt( 'zapier_attach_pdf', 0 ) . ",
                `attach_csv`  = " . JRequest::getInt( 'zapier_attach_csv', 0 ) . ",
                `attach_xml`  = " . JRequest::getInt( 'zapier_attach_xml', 0 ) . ",
                `webhooks`  = " . $db->quote( JRequest::getVar( 'zapier_webhooks', '' ) ) . "
                 Where form_id = " . intval( $form_id ) . "
            " );
			    $db->execute();
		    }
	    }
    }
    
    function onPropertiesExecute($processor){
        
        if(!$processor->form) return;
        
        $db = JFactory::getDBO();
        
        $db->setQuery("Select * From #__breezingforms_addons_zapier Where form_id = " . intval($processor->form));
        $tg = $db->loadObject();
        
        if( $tg === null ){
            $tg = new stdClass();
            $tg->id = 0;
            $tg->form_id = 0;
            $tg->head_data = 0;
            $tg->enabled = 0;
            $tg->exclude_fields = '';
            $tg->attach_pdf = 0;
            $tg->attach_csv = 0;
            $tg->attach_xml = 0;
	        $tg->webhooks = '';
        }
        
        if( $tg->enabled == 1 ){
            
            try{
            
                jimport('joomla.version');
                $version = new JVersion();
                $_version = $version->getShortVersion();
                $tz = 'UTC';
                if(version_compare($_version, '3.2', '>=')){
                    $tz = new DateTimeZone(JFactory::getApplication()->getCfg('offset'));
                }

                $submitted = $processor->submitted;
                if(version_compare($_version, '3.2', '>=')){
                    $date_ = JFactory::getDate($processor->submitted, $tz);
                    $offset = $date_->getOffsetFromGMT();
                    if($offset > 0){
                        $date_->add(new DateInterval('PT'.$offset.'S'));
                    }else if($offset < 0){
                        $offset = $offset*-1;
                        $date_->sub(new DateInterval('PT'.$offset.'S'));
                    }

                    $submitted = $date_->format('Y-m-d H:i:s', true);
                }

	            $post = array();
	            $post[$processor->formrow->name] = array();

                $head = '';
                
                if( $tg->head_data == 1 ){

                    $head = 
                    BFText::_('COM_BREEZINGFORMS_PROCESS_FORMID') . ": " . $processor->form . "\r\n" .
                    BFText::_('COM_BREEZINGFORMS_PROCESS_RECORDSAVEDID') . ": " . $processor->record_id . "\r\n" .
                    BFText::_('COM_BREEZINGFORMS_PROCESS_FORMTITLE') . ": " . $processor->formrow->title . "\r\n" .
                    BFText::_('COM_BREEZINGFORMS_PROCESS_FORMNAME') . ": " . $processor->formrow->name . "\r\n" .
                    BFText::_('COM_BREEZINGFORMS_PROCESS_SUBMITTEDAT') . ": " . $submitted . "\r\n" .
                    BFText::_('COM_BREEZINGFORMS_PROCESS_SUBMITTERIP') . ": " . $processor->ip . "\r\n" .
                    BFText::_('COM_BREEZINGFORMS_PROCESS_SUBMITTERID') . ": " . JFactory::getUser()->get('id', 'Not logged in') . "\r\n" .
                    BFText::_('COM_BREEZINGFORMS_PROCESS_SUBMITTERUSERNAME') . ": " . JFactory::getUser()->get('username', 'Not logged in') . "\r\n" .
                    BFText::_('COM_BREEZINGFORMS_PROCESS_SUBMITTERFULLNAME') . ": " . JFactory::getUser()->get('name', 'Not logged in') . "\r\n" .
                    BFText::_('COM_BREEZINGFORMS_PROCESS_PROVIDER') . ": " . $processor->provider . "\r\n" .
                    BFText::_('COM_BREEZINGFORMS_PROCESS_BROWSER') . ": " . $processor->browser . "\r\n" .
                    BFText::_('COM_BREEZINGFORMS_PROCESS_OPSYS') . ": " . $processor->opsys . "\r\n\r\n";

	                $post[$processor->formrow->name]['bf_formid'] = $processor->form;
	                $post[$processor->formrow->name]['bf_record_id'] = $processor->record_id;
	                $post[$processor->formrow->name]['bf_formtitle'] = $processor->formrow->title;
	                $post[$processor->formrow->name]['bf_formname'] = $processor->formrow->name;
	                $post[$processor->formrow->name]['bf_submittedat'] = $submitted;
	                $post[$processor->formrow->name]['bf_submitterip'] = $processor->ip;
	                $post[$processor->formrow->name]['bf_submitterid'] = JFactory::getUser()->get('id', 'Not logged in');
	                $post[$processor->formrow->name]['bf_submitterusername'] = JFactory::getUser()->get('username', 'Not logged in');
	                $post[$processor->formrow->name]['bf_submitterfullname'] = JFactory::getUser()->get('name', 'Not logged in');
	                $post[$processor->formrow->name]['bf_provider'] = $processor->provider;
	                $post[$processor->formrow->name]['bf_browser'] = $processor->browser;
	                $post[$processor->formrow->name]['bf_opsys'] = $processor->opsys;
                }

	            $id =  uniqid();
	            $zapier_folder = JPATH_SITE . '/media/breezingforms/plugins/zapier/' . $id . '/';
	            $zapier_webfolder = Juri::root() . 'media/breezingforms/plugins/zapier/' . $id . '/';

                $uploads = array();
                $msg = '';

                $filter = explode("\n", str_replace("\r","",$tg->exclude_fields));

                foreach($processor->savedata As $data){

                	if (!in_array($data[_FF_DATA_NAME], $filter)) {

                		$val = $data[_FF_DATA_VALUE];

		                if($data[_FF_DATA_TYPE] == 'File Upload'){

			                $val = basename($val);
		                }

		                $post[$processor->formrow->name][strip_tags($data[_FF_DATA_NAME])] = strip_tags(str_replace('<br />',"\r\n",$val));

                        $msg .= strip_tags($data[_FF_DATA_TITLE]).': '.strip_tags(str_replace('<br />',"\r\n",$val))."\r\n";
		                $msg .= "\r\n";
                    }

                    if (!in_array($data[_FF_DATA_NAME], $filter) && $data[_FF_DATA_TYPE] == 'File Upload') {

                        $the_files = explode("\n", $data[_FF_DATA_VALUE]);

                        foreach($the_files As $the_file){
                            if(trim($the_file) != ''){
                                $uploads[strip_tags($data[_FF_DATA_NAME])] = $the_file;

	                            if(!isset($post[$processor->formrow->name][strip_tags($data[_FF_DATA_NAME]) . '_files'])){
		                            $post[$processor->formrow->name][strip_tags($data[_FF_DATA_NAME]) . '_files'] = '';
	                            }

	                            $post[$processor->formrow->name][strip_tags($data[_FF_DATA_NAME]) . '_files'] .= $zapier_webfolder . basename($the_file) . "\n";
                            }
                        }
                    }
                    else if (!in_array($data[_FF_DATA_NAME], $filter) && $data[_FF_DATA_TYPE] == 'Signature') {

	                    $the_file = JPATH_SITE . '/media/breezingforms/signatures/' . basename($data[_FF_DATA_VALUE]);

	                    if(JFile::exists($the_file)){

		                    $uploads[strip_tags($data[_FF_DATA_NAME])] = $the_file;

		                    if(!isset($post[$processor->formrow->name][strip_tags($data[_FF_DATA_NAME]) . '_files'])){
			                    $post[$processor->formrow->name][strip_tags($data[_FF_DATA_NAME]) . '_files'] = '';
		                    }

		                    $post[$processor->formrow->name][strip_tags($data[_FF_DATA_NAME]) . '_files'] .= $zapier_webfolder . basename($the_file) . "\n";
	                    }
                    }
                }

				$webhooks = explode("\n", str_replace("\r","",$tg->webhooks));

				if( count($webhooks) == 0 || trim($webhooks[0]) == '' ){
					throw new Exception();
				}



				if(!JFolder::exists($zapier_folder)) {

					JFolder::create( $zapier_folder );
				}

				$new_uploads = array();


	            foreach ( $uploads As $key => $upload ) {

	            	JFile::copy($upload, $zapier_folder.basename($upload));

		            $new_uploads[] = $zapier_folder . basename($upload);
	            }

				foreach($webhooks As $webhook) {

					if(trim($webhook) == ''){

						continue;
					}

					$the_msg = BFText::_('COM_BREEZINGFORMS_ZAPIER_NEW_RECORD')."\r\n\r\n";
					$the_msg .= $head.$msg;

					foreach ( $new_uploads As $upload ) {

						$the_msg .= str_replace(JPATH_SITE, rtrim(JUri::root(),'/') , $upload)."\r\n\r\n";
					}

					if ( $tg->attach_pdf ) {
						$pdf = $processor->exppdf();
						JFile::copy($pdf, $zapier_folder.basename($pdf));
						JFile::delete( $pdf );
						$the_msg .= $post[$processor->formrow->name]['bf_pdf'] = str_replace(JPATH_SITE, rtrim(JUri::root(),'/') , $zapier_folder . basename($pdf))."\r\n\r\n";
					}

					if ( $tg->attach_csv ) {
						$csv = $processor->expcsv();
						JFile::copy($csv, $zapier_folder.basename($csv));
						JFile::delete( $csv );
						$the_msg .= $post[$processor->formrow->name]['bf_csv'] = str_replace(JPATH_SITE, rtrim(JUri::root(),'/') , $zapier_folder . basename($csv))."\r\n\r\n";
					}

					if ( $tg->attach_xml ) {
						$xml = $processor->expxml();
						JFile::copy($xml, $zapier_folder.basename($xml));
						JFile::delete( $xml );
						$the_msg .= $post[$processor->formrow->name]['bf_xml'] = str_replace(JPATH_SITE, rtrim(JUri::root(),'/') , $zapier_folder . basename($xml))."\r\n\r\n";
					}


					$the_msg .= "\r\n" . BFText::_('COM_BREEZINGFORMS_ZAPIER_END_RECORD');

					$post[$processor->formrow->name]['bf_record'] = $the_msg;

					$json = json_encode($post);

					$headers = array('Accept: application/json', 'Content-Type: application/json');

					$ch = curl_init();
					curl_setopt($ch, CURLOPT_URL, $webhook);
					curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
					curl_setopt($ch, CURLOPT_TIMEOUT, 10);
					curl_setopt($ch, CURLOPT_CUSTOMREQUEST, 'POST');
					curl_setopt($ch, CURLOPT_POST, 1);
					curl_setopt($ch, CURLOPT_POSTFIELDS, $json);
					curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
					curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
					curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);
					curl_setopt($ch, CURLOPT_SSLVERSION, 6); //6 is for TLSV1.2

					$output = curl_exec($ch);

					curl_close($ch);
				}
            
            }catch(Exception $e){
                // nothing, be silent
            }
        }
    }
}
