<?php
/**
 * @version		1.0 Lucky Orange
 * @copyright	Copyright (C) 2015 Lucky Orange LLC. All rights reserved.
 * @license		GNU/GPL, see LICENSE.php
 * Updated		3 March 2015
 *
 * Info: http://www.luckyorange.com
 *
 * Joomla! is free software. This version may have been modified pursuant
 * to the GNU General Public License, and as distributed it includes or
 * is derivative of works licensed under the GNU General Public License or
 * other free or open source software licenses.
 * See COPYRIGHT.php for copyright notices and details.
 *
 */

defined('_JEXEC') or die('Restricted access');

class plgSystemLuckyOrange extends JPlugin
{
	function saveParam($param, $value) {
		
		$this->params->set($param, $value);
		
		// Save params in DB
		$db = JFactory::getDbo();
		$query = $db->getQuery(true)
			->update($db->quoteName('#__extensions'))
			->set($db->quoteName('params') . ' = ' . $db->quote($this->params->toString()))
			->where($db->quoteName('type') . ' = ' . $db->quote('plugin'))
			->where($db->quoteName('element') . ' = ' . $db->quote('luckyorange'));
		
		$db->setQuery($query);
		$result = $db->execute();
		return $result;
	}
	
	function onAfterRender() {
		
		$app = JFactory::getApplication();
		$buffer = JResponse::getBody();
		$output = '<script type="text/javascript">' . "\n";
		
		if ( $app->isAdmin() ) {
			
			$has_shown_tooltip = $this->params->get('has_shown_tooltip');
			$user = JFactory::getUser();
			$site_url = urlencode(JURI::root());
			$email = urlencode($user->email);
			$name = $user->name;
			if ( $name == null || $name == '' || !$name ) {
				$name = $user->username;
			}
			$name = urlencode($name);
			$href = 'http://www.luckyorange.com/plugin.php?t=joomla&e=' . $email . '&u=' . $site_url . '&n=' . $name;
			$output .= '
			(function(w) {
				
				var addLink = function() {
					jQuery(document).ready(function() {
						jQuery("nav:first #menu")
							.append("<li><a id=\'lucky-nav-link\' href=' . $href . ' target=\'_blank\' title=\'Click here to get started with Lucky Orange\'>Lucky Orange</a></li>")
							.children()
							.last()
							.children()
							.first()
							.prepend("<img src=\'//cdn.luckyorange.com/graphics/16x16_joomla.png\' width=\'16\' height=\'16\' alt=\'Lucky Orange logo\' style=\'margin-right: 5px;vertical-align: text-bottom;\' />");';
						
			if ( $has_shown_tooltip == null || $has_shown_tooltip == 0 || $has_shown_tooltip == '0' || $has_shown_tooltip == false ) {
				
				$output.= '
				var $link = jQuery("#lucky-nav-link");
				$link.attr("data-toggle", "tooltip").tooltip({"trigger":"manual", "placement":"bottom", "delay":1000}).tooltip("show");
				setTimeout(function () {
					$link.tooltip("hide");
					$link = null;
				}, 30 * 1000);';
				
				$this->saveParam('has_shown_tooltip', '1');
			}
			
			$output .= '
					});
				};
				
				if ( typeof jQuery === "undefined" ) {
					
					var script = document.createElement("script");
					
					script.type = "text/javascript";
					script.src = "https://ajax.googleapis.com/ajax/libs/jquery/2.1.3/jquery.min.js";
					
					document.getElementsByTagName("head")[0].appendChild(script);
					
					// jQuery MAY OR MAY NOT be loaded at this stage
					var waitForLoad = function() {
					    if ( typeof jQuery !== "undefined" ) {
					        addLink();
					    } else {
					        window.setTimeout(waitForLoad, 1000);
					    }
					};
					
					window.setTimeout(waitForLoad, 1000);
				}
				
				else {
					addLink();
				}
				
			})(window);
			</script>
			</head>';
			
		}
		
		else {
		
			if ( strlen( ( $site_id = $this->params->get('site_id') ) ) > 0 ) {
				$output .= 'window.__wtw_lucky_site_id = ' . $site_id . ";\n";
			}
			
			$output .= '
			(function() {
				var wa = document.createElement("script"); wa.type = "text/javascript"; wa.async = true;
				wa.src = ("https:" == document.location.protocol ? "https://ssl" : "http://cdn") + ".luckyorange.com/w.js";
				var s = document.getElementsByTagName("script")[0]; s.parentNode.insertBefore(wa, s);
			})();
			</script>
			</head>';
		}
		
		if ( strlen($output) > 0 ) {
			
			$buffer = preg_replace("/<\/head>/", $output, $buffer);
			
			if ( $buffer != NULL ) {
				JResponse::setBody($buffer);
			}
		}

		return true;
	}
	
	/*
		Called if, and only if, plugin is enabled and is being updated/reinstalled.
	*/
/*
	function onInstallerAfterInstaller() {
		// stub
	}
	
	function onExtensionAfterInstall($installer, $eid) {
		$app = JFactory::getApplication();
		$input = $app->input;
		// $input->set('lol_installed', true);
		echo '<pre>';
		print_r($input);
		echo '</pre>';
		exit;
	}
*/
	
/*
	function onInstallerAfterInstaller() {
		$app = JFactory::getApplication();
		$input = $app->input;
		$msg_tmpl = 'Thank you for %s the Lucky Orange plugin! To get started tracking your visitors, please click the Lucky Orange link above.';
		$action;
		
		switch ( $route ) {
			
			case 'install':
			case 'discover_install':
			default:
				$action = 'installing';
			break;
			
			case 'update':
				$action = 'updating';
			break;
		}
		
		$msg = sprintf($msg_tmpl, $action);
		
		if ( $route === 'install' || $route === 'update' || $route === 'discover_install' ) {
			$html = JResponse::getBody();
			$html = htmlentities($html);
			JResponse::setBody($msg . "\n\n\n\n" . $html);
		}
	}
*/
}
?>