<?php
	
function luckyorange_postinstall_condition()
{
	$db = JFactory::getDbo();
	$query = lol_query_for_enabled_state('1');
	$db->setQuery($query);
	$enabled_plugins = $db->loadObjectList();
	
	// Return false if the plugin isn't enabled
	//
	return count($enabled_plugins) == 0;
}

function luckyorange_postinstall_action() {
	// Enable the plugin
	$app = JFactory::getApplication();
	$db = JFactory::getDbo();
	
	$query = lol_query_for_enabled_state('0');
	$db->setQuery($query);
	
	$enabled_plugins = $db->loadObjectList();
	
	$query = lol_query_for_enabled_state('1');
	
	$db->setQuery($query);
	$db->execute();
	
	// Redirect the user to the plugin configuration page
	//
	$url = 'index.php?option=com_plugins&task=plugin.edit&extension_id=' . $enabled_plugins[0]->extension_id;
	$app->redirect($url);
}

function lol_query_for_enabled_state($enabled_state = '1') {
	$query = $db->getQuery(true)
		->select('*')
		->from($db->quoteName('#__extensions'))
		->where($db->quoteName('type') . ' = ' . $db->quote('plugin'))
		->where($db->quoteName('enabled') . ' = ' . $db->quote($enabled_state))
		->where($db->quoteName('folder') . ' = ' . $db->quote('system'))
		->where($db->quoteName('element') . ' = ' . $db->quote('luckyorange'));
	return $query;
}
