<?php

if(!isset($_SESSION))
    session_start();
include '../../connection.php';

## Read Value 
$draw = $_POST['draw'];
$row = $_POST['start'];
$rowperpage = $_POST['length'];
$columnIndex = $_POST['order'][0]['column'];
$columnName = $_POST['columns'][$columnIndex]['data'];
$columnSortOrder = $_POST['order'][0]['dir'];
$searchValue = trim($_POST['search']['value']);
$fillter_vendors = $_POST['fillter_vendors'];
$order_id = $_POST['order_id'];

$shipper = $_POST['shipper'];
$startDate = $_POST['startDate'];
$endDate = $_POST['endDate'];
$archive = $_POST['archive'];
$threshold = (isset($_POST["threshold"]) && !empty($_POST["threshold"])) ? $_POST["threshold"] : 10;
$compare = $_POST['compare'];
$searchStr = '';

if(empty($order_id)){

    if(!empty($fillter_vendors)){
       $searchStr .= " and `vendor` = '$fillter_vendors'";
    }
    
    if(!empty($archive)){
        $searchStr .= " and `archive` = '1' ";    
    }
    else{
        $searchStr .= " and `archive` <> '1' ";    
    }
}
else{
    $searchStr .= " and `id`=".$order_id;
}

if(!empty($searchValue))
{
    $searchStr= " and  (
        `report_we` like '%".$searchValue."%' or
        `name` like '%".$searchValue."%' or
        `invoice_cost` like '%".$searchValue."%' or
        `invoice_product_total` like '%".$searchValue."%' or
        `invoice_freight` like '%".$searchValue."%' or
        `order_total` like '%".$searchValue."%' or
        `new_ton_pricing_product` like '%".$searchValue."%'  or
        `order_sheet_shipping` like '%".$searchValue."%' or
        `shipper` like '%".$searchValue."%' or
        `vendor`  like `%".$searchValue."%' or
        `tracking` like '%".$searchValue."%' or
        `review_note` like '%".$searchValue."%' or
        `inv` like '%".$searchValue."%') ";
}

  
    
if(!empty($compare)){
    $invoices_data = explode("\n",$compare);
    foreach($invoices_data as $key => &$value){
        if(!empty($value)){
            $value = explode(",",$value);            
        }
    }
}

$invoices_not_exists = [];
$invoices_not_match = [];
if(is_array($invoices_data) && count($invoices_data) != 0){
        foreach($invoices_data as $inv => $v){

            $sql_check_invoice = "SELECT * FROM `invoices_sheet` WHERE `inv`='{$v[0]}'";
            $execute_check_invoice = mysqli_query($connect,$sql_check_invoice);
            if($execute_check_invoice){
                $inv = mysqli_fetch_assoc($execute_check_invoice);
                if($inv){
                    $inv["on_report"] = 1;
                    update_field($connect, "on_report", $inv["on_report"], $inv["id"]);
                    
                    if($v[1] == $inv["invoice_cost"]){
                        $inv["matches_report"] = 1;
                        update_field($connect, "matches_report", $inv["matches_report"], $inv["id"]);
                    }
                    else{
                        $invoices_not_match[] = $v[0];
                    }
                }
                else{
                    $invoices_not_exists[] = $v[0];
                }
            }
        }
    }


$archiveConditions = "";
if(isset($shipper) && !empty($shipper)){
    $archiveConditions .= " AND ( shipper = '$shipper' )";
}
if((isset($startDate) && !empty($startDate)) && (isset($endDate) && !empty($endDate))){
    $archiveConditions .= " AND ( report_we >= '".date('m/d/Y',strtotime($startDate))."' && report_we <= '".date('m/d/Y', strtotime($endDate))."')";
}
if((isset($startDate) && !empty($startDate)) && (!isset($endDate) || empty($endDate))){
    $archiveConditions .= " AND ( report_we >= '".date('m/d/Y',strtotime($startDate))."')";
}
if((isset($endDate) && !empty($endDate)) && (!isset($startDate) || empty($startDate))){
    $archiveConditions .= " AND ( report_we <= '".date('m/d/Y',strtotime($startDate))."')";
}
if(isset($archive) && $archive == 1){
    $archiveConditions .= " AND ( archive = 1 )";
}
else{
    $archiveConditions .= " AND ( archive = 0 )";        
}


## total number of records without filtering
$selTo = "select count(*) as allcount FROM invoices_sheet WHERE 1";
$sel = mysqli_query($connect,$selTo);
$records = mysqli_fetch_assoc($sel);
$totalRecords = $records['allcount'];


## total number of records with filtering
$sqlNum = "select count(*) as allcount FROM invoices_sheet where 1 ".$searchStr." ".$archiveConditions;

$sel = mysqli_query($connect,$sqlNum);
$records = mysqli_fetch_assoc($sel);
$totalRecordWithFilter = $records['allcount'];




$invoicesSql = "SELECT * FROM `invoices_sheet` WHERE 1 ".$searchStr." ".$archiveConditions." ORDER BY id asc limit ".$row.",".$rowperpage;

$executeInvoices = mysqli_query($connect,$invoicesSql);
$data = array();
$count = 1;
$name = "";
while($row = mysqli_fetch_assoc($executeInvoices))
{

    $sql_get_order = "SELECT * FROM `orders` WHERE tracking='".$row["tracking"]."'";
    $execute_get_order = mysqli_query($connect,$sql_get_order);
    $order = mysqli_fetch_assoc($execute_get_order);
    if($order){
        if(empty($row["new_ton_pricing_product"]) || $row["is_updated"] == 1){
            $row["new_ton_pricing_product"] = $order["pelletcost"];
            update_field($connect, "new_ton_pricing_product", $row["new_ton_pricing_product"], $row["id"]);            
        }
        
        if(empty($row["order_sheet_shipping"]) || $row["is_updated"] == 1){
            $row["order_sheet_shipping"] = str_replace(",", "", $order["shippingprice"]);
            update_field($connect, "order_sheet_shipping", $row["order_sheet_shipping"], $row["id"]);
        }        

        if(empty($row["order_total"]) || $row["is_updated"] == 1){
            $row["order_total"] =  (!empty($order["totalcost_del"])) ? str_replace(",", "", $order["totalcost_del"]) : (double) str_replace(",", "", $order["pelletcost"]) +  (double) str_replace(",", "", $order["shippingprice"]);
            update_field($connect, "order_total", $row["order_total"], $row["id"]);
        }    
        
        update_field($connect, "is_updated", 0, $row["id"]);

        $row["vendor"] = $order["vendor"];
        update_field($connect, "vendor", $row["vendor"], $row["id"]);

        if($row["tracking"] == "") {
            $row["order_id"] = "";
        } else {
            $row["order_id"] = $order["id"];
            update_field($connect, "order_id", $row["order_id"], $row["id"]);
        }
        
        
    }
    if($row["order_total"] == 0){
            $row["order_total"] = $row["new_ton_pricing_product"] + $row["order_sheet_shipping"];
            update_field($connect, "order_total", $row["order_total"], $row["id"]);
    }

    if($row["archive"] == 1){
        $archive = "CHECKED";
    }
    else{
        $archive = "";
    }  
    if($row["on_report"] == 1){
        $on_report = "CHECKED";
    }
    else{
        $on_report = "";
    }  
  
    if(stripos($row["shipper"],"Central") !== false){
        if($row["invoice_freight"] == 0){
            $row["shipper"] = "CTL2";
            update_field($connect, "shipper", "CTL2", $row["id"]);            
        }

    }
    if(stripos($row["shipper"],"Central") !== false){
        $tracking_link = "<a target='_BLANK' href='https://www.centraltransport.com/tools/track-shipment'>".$row["tracking"]."</a>";
    }
    elseif(stripos($row["shipper"],"CTL2") !== false){
        $tracking_link = "<a target='_BLANK' href='https://www.centraltransport.com/tools/track-shipment'>".$row["tracking"]."</a>";
    }
    elseif(stripos($row["shipper"],"Dohrn") !== false){
        $tracking_link = "<a target='_BLANK' href='https://dohrn.com/tools/track-by-pro-number'>".$row["tracking"]."</a>";
    }
    elseif(stripos($row["shipper"],"Speedee") !== false){
        $tracking_link = "<a target='_BLANK' href='https://speedeedelivery.com/track-a-shipment/'>".$row["tracking"]."</a>";
    }
    elseif(stripos($row["shipper"],"Magnum") !== false){
        $tracking_link = "<a target='_BLANK' href='https://magnumlog.com/track-shipment'>".$row["tracking"]."</a>";
    }    
    else{
        $tracking_link = $row["tracking"];
    }
    $threshold_class = '';
    if(isset($threshold) && !empty($threshold)){
        $diff = abs($row["invoice_cost"] - $row["order_total"]);
        if($diff > $threshold){
            $threshold_class = "text-danger";
            $row["matches_report"] = 0;
            update_field($connect, "matches_report", $row["matches_report"], $row["id"]);
        }
        else{
            $row["matches_report"] = 1;
            update_field($connect, "matches_report", $row["matches_report"], $row["id"]);
        }
    }
    
    if($row["matches_report"] == 1){
        $matches_report = "checked";
    }
    else{
       $matches_report = "";
    }    

    if (in_array($row["inv"], $invoices_not_match))
    {
        $not_match_compare = "text-danger";
    }
    else
    {
        $not_match_compare = "";        
    }
    
    if($row["order_id"] == "") {
        $name = "<p>{$row["name"]}</p>";
    } else {
        $name = "<a target='_BLANK' href='https://worldsbestscraper.com/api/bbqpelletsonline/orders/?id={$row["order_id"]}'>".$row["name"]."</a>";
    }
    if($row["new_ton_pricing_product"] != $row["invoice_product_total"]){
        $exp_prod = "text-danger";
    }
    else{
        $exp_prod = "";
    }
    
    if($row["order_sheet_shipping"] != $row["invoice_freight"]){
        $exp_ship = "text-danger";
    }
    else{
        $exp_ship = "";
    }
    
    $data[] = array(
        "id" => $row["id"],
        "number" => $count,
        "report_we" => date('m/d',strtotime($row["report_we"])),
        "name" => $name,
        "invoice_cost" =>  ($row["invoice_cost"]) ? "<span class='$not_match_compare'>"."$".number_format($row["invoice_cost"],2)."</span>" : "",
        "invoice_product_total" => ($row["invoice_product_total"]) ? "$".number_format($row["invoice_product_total"],2) : "",
        "invoice_freight" => ($row["invoice_freight"]) ? "$".number_format($row["invoice_freight"],2) : "",
        "order_total" => ($row["order_total"]) ? "<span class='$threshold_class'>"."$".number_format($row["order_total"],2)."</span>" : "",
        "new_ton_pricing_product" => ($row["new_ton_pricing_product"]) ? "<span class='$exp_prod'>"."$".number_format($row["new_ton_pricing_product"],2)."</span>" : "",
        "order_sheet_shipping" => ($row["order_sheet_shipping"]) ? "<span class='$exp_ship'>"."$".number_format($row["order_sheet_shipping"],2)."</span>" :  "",
        "tracking" => $tracking_link,
        "inv" => $row["inv"],
        "shipper" => $row["shipper"],
        "vendor" => (empty($row["vendor"])) ? "" : $row["vendor"],
        "review_note" => "<textarea class='form-control change_note_{$row["id"]}' data-id='{$row["id"]}' rows='4'>".$row["review_note"]."</textarea><button class='btn btn-primary save-note mt-2' data-id='{$row["id"]}' >Save note</button>",
        "on_report" => "<input type='checkbox' class='change-on_report' id='{$row["id"]}' $on_report>",
        "matches_report" => "<input type='checkbox' class='change-matches_report' id='{$row["id"]}' $matches_report>",
        "archive" => "<input type='checkbox' class='change-archive' id='{$row["id"]}' $archive>",
        "edit"  => "<button class='btn btn-primary btn-edit' data-data='".json_encode($row)."' data-id='{$row["id"]}'><i class='fas fa-edit'></i></button>",
    );
    $count++;
}

if(count($invoices_not_exists) > 0){
    $flag_not_exists_flag = true;
}
else{
    $flag_not_exists_flag = false;    
}

$response = array(
   "draw" => intval($draw),
    "iTotalRecords" => $totalRecordWithFilter,
    "iTotalDisplayRecords" => $totalRecordWithFilter,
    "aaData" => $data,
    "invoices_not_exists"       =>implode("\n",$invoices_not_exists),
    "invoices_not_exists_flag"  => $flag_not_exists_flag,
);


echo json_encode($response);

function update_field($connect, $column_name, $value, $id){
    $update_sql = "UPDATE `invoices_sheet` SET `$column_name`='$value' WHERE id=".$id;
    mysqli_query($connect, $update_sql);
}


?>