var last_open_form = 0;

$(document).ready(function(){
    
    
    var url = parseURLParams(window.location.href);
    var id = '';
    if(url && url.order_id){
        id = url.order_id[0];
    }
    fetch_data();
   
    $(document).on('click','.btn-show-invoice',function(){
            $("#NewInvoice iframe").attr("src",""); 
            var id = $(this).data("invoice");

            $(".invoice-number span").text(id);
                        
            $("#NewInvoice iframe").attr("src","https://new.bbqpelletsonline.com/automation/public_html/freshbooks/get_invoice_details.php?invoice_id="+id); 
    
            setTimeout(function(){ 
                $("#NewInvoice").modal("show"); 
            }, 500);
    });
    
    $(document).on('click','.btn-compare-invoices',function(){
        var values = $("#invoices_comparion_input").val();
                
        var startDate = $("#startDate").val();
        var endDate = $("#endDate").val();
        var shipper = $("#fillter_shipper").val();

        var archive = $("#archive_flag").is(":checked");
        if(archive){
            archive = 1;
        }
        else{
            archive = 0;
        }
        
        if(values != ''){
            fetch_data(shipper,startDate,endDate,archive,null,values);
            $("#invoices_comparion_input").val("");
        }
        $("#invoices_comparion").modal("hide");
    });    
    
  
   
    $(document).on('change','#fillter_shipper',function(){

       var shipper = $(this).val();

       fetch_data(shipper);
   });
   
    $(document).on('click','.btn-search-date',function(){

       var startDate = $("#startDate").val();
       var endDate = $("#endDate").val();
       var shipper = $("#fillter_shipper").val();
       fetch_data(shipper,startDate,endDate);
   });   
   
  $(document).on('click','#archive_flag',function(){
      var id = $(this).data('id');
      var archive = $(this).is(":checked");
      if(archive){
          archive = 1;
      }
      else{
          archive = 0;
      }
       
      var startDate = $("#startDate").val();
      var endDate = $("#endDate").val();
      var shipper = $("#fillter_shipper").val();
      fetch_data(shipper,startDate,endDate,archive);
  }); 
  
    
    
   $(document).on('click','#check_diff',function(){
       var threshold = $("#Threshold").val();
       var archive = $("#archive_flag").is(":checked");
       if(archive){
           archive = 1;
       }
       else{
           archive = 0;
       }
       
       var startDate = $("#startDate").val();
       var endDate = $("#endDate").val();
       var shipper = $("#fillter_shipper").val();
       fetch_data(shipper,startDate,endDate,archive,threshold);
   });    
   
  
    $('#invoices_table').on('click', '.change-archive',  function () {
       var invoice_id = $(this).attr("id");
       var check = $(this).data("check");
       var value = $(this).is(":checked");
       var $that = $(this);
       if(value){
           value = 1;
       }
       else{
           value = 0;
       }
       if(value == 1){
            Swal.fire({
              title: 'Are you sure you want to ARCHIVE?',
              showCancelButton: true,
              type: 'info',
              confirmButtonText: `Save`,
            }).then((result) => {
              if (result.value) {
                 $.ajax({
                            type: "POST",
                            url: "assets/ajax/update_invoice.php",
                            data:{
                                "id"     : invoice_id,
                                "archive": value,
                            },
                            success:function(data)
                            {
                                if(data == "somthingWrong")
                                {
                                    Swal.fire({
                                        title:"Somthing Wrong",
                                        text:"Please Try Again",
                                        type:"warning",
                                        confirmButtonText:"Ok"
                                    }).then( () => {
                                        location.reload();
                                    });                                
                                }
                                fetch_data();
                            }
                  });               
              } else{
                $that.prop("checked",false);                        
              }
            });
       }
       else{
         $.ajax({
                    type: "POST",
                    url: "assets/ajax/update_invoice.php",
                    data:{
                        "id"     : invoice_id,
                        "archive": value,
                    },
                    success:function(data)
                    {
                        if(data == "somthingWrong")
                        {
                            Swal.fire({
                                title:"Somthing Wrong",
                                text:"Please Try Again",
                                type:"warning",
                                confirmButtonText:"Ok"
                            }).then( () => {
                                location.reload();
                            });                      
                                fetch_data();
                        }
                    }
          });           
       }

 
    });
    $(document).on('change','.fillter_vendors',function(){
        fetch_data();
    })
    
    $('#invoices_table').on('click', '.change-matches_report',  function () {
       var invoice_id = $(this).attr("id");
       var value = $(this).is(":checked");
       if(value){
           value = 1;
       }
       else{
           value = 0;
       }
        $.ajax({
            type: "POST",
            url: "assets/ajax/update_invoice.php",
            data:{
                "id"     : invoice_id,
                "matches_report": value,
            },
            success:function(data)
            {
                if(data == "somthingWrong")
                {
                    Swal.fire({
                        title:"Somthing Wrong",
                        text:"Please Try Again",
                        type:"warning",
                        confirmButtonText:"Ok"
                    }).then( () => {
                        location.reload();
                    });                                
                }
                fetch_data();
            }
        });
    });

    $('#invoices_table').on('click', '.change-on_report',  function () {
       var invoice_id = $(this).attr("id");
       var value = $(this).is(":checked");
       if(value){
           value = 1;
       }
       else{
           value = 0;
       }
        $.ajax({
            type: "POST",
            url: "assets/ajax/update_invoice.php",
            data:{
                "id"     : invoice_id,
                "on_report": value,
            },
            success:function(data)
            {
                if(data == "somthingWrong")
                {
                    Swal.fire({
                        title:"Somthing Wrong",
                        text:"Please Try Again",
                        type:"warning",
                        confirmButtonText:"Ok"
                    }).then( () => {
                        location.reload();
                    });                                
                }
                fetch_data();
            }
        });
    });
                  
            
    $(document).on('show.bs.modal', '.modal', function () {
        var zIndex = 1040 + (10 * $('.modal:visible').length);
        $(this).css('z-index', zIndex);
        setTimeout(function() {
            $('.modal-backdrop').not('.modal-stack').css('z-index', zIndex - 1).addClass('modal-stack');
        }, 0);
    });
    
    
    $(document).on('click','.btn-add-order',function(){
        var data = $("#add-order").serialize();
      $.ajax({
            type: "POST",
            url: "assets/ajax/add_new_invoice.php?"+data,
            data:{
            },
            success:function(data)
            {
                console.log(data);
                location.reload();
            }
        });  
    });
    
    $(document).on('click','.btn-edit',function(){
        var id = $(this).data("id");
        var data = $(this).data("data");
        
        $("#edit-modal").modal("show");
        $("#tracking_number").val(data.tracking);
        $("#invoice_id").val(data.id);
        $("#shipper").val(data.shipper);
        $("#edit_invoice_cost").val(data.invoice_cost);
        $("#edit_order_total").val(data.order_total);
        $("#edit_invoice_product_total").val(data.invoice_product_total);
        $("#edit_new_ton_pricing_product").val(data.new_ton_pricing_product);
        $("#edit_invoice_freight").val(data.invoice_freight);
        $("#edit_order_sheet_shipping").val(data.order_sheet_shipping);
 
    });    
    
    $(document).on('click','.save_edit_invoice',function(){
        
        var tracking = $("#tracking_number").val();
        var invoice_id = $("#invoice_id").val();
        var shipper = $("#shipper").val();
        var invoice_cost = $("#edit_invoice_cost").val();
        var order_total = $("#edit_order_total").val();
        var invoice_product_total = $("#edit_invoice_product_total").val();
        var new_ton_pricing_product = $("#edit_new_ton_pricing_product").val();
        var invoice_freight = $("#edit_invoice_freight").val();
        var order_sheet_shipping = $("#edit_order_sheet_shipping").val();
 
       $.ajax({
            type: "POST",
            url: "assets/ajax/update_invoice.php",
            data:{
                "id"            : invoice_id,
                "shipper"   : shipper,
                "tracking"   : tracking,
                "invoice_cost"   : invoice_cost,
                "order_total"   : order_total,
                "invoice_product_total"   : invoice_product_total,
                "new_ton_pricing_product"   : new_ton_pricing_product,
                "invoice_freight"   : invoice_freight,
                "order_sheet_shipping"   : order_sheet_shipping,
            },
            success:function(data)
            {
                if(data == "somthingWrong")
                {
                    Swal.fire({
                        title:"Somthing Wrong",
                        text:"Please Try Again",
                        type:"warning",
                        confirmButtonText:"Ok"
                    }).then( () => {
                        
                    });                                
                }
                last_open_form = invoice_id;
                $("#edit-modal").modal("hide");                
                fetch_data();
            }
        });

    });        
    
    
    
    
});

function format( d ) {
    return '<table cellspacing="0" class="sub_table order_'+d.id+'" border="0" width="100%">'+
        '<tr>'+
            '<td>Inv Product Total:</td>'+
            '<td><label class="invoice_product_total_'+d.id+'" value="'+d.invoice_product_total+'">'+d.invoice_product_total+'</label></td>'+
            '<td>Inv Shipping Total:</td>'+
            '<td>'+d.invoice_freight+'</td>'+
            '<td rowspan="2">Review Notes:</td>'+
            '<td rowspan="2">'+ d.review_note +'</td>'+
        '</tr>'+
        '<tr>'+
            '<td>Expected Product Total:</td>'+
            '<td>'+d.new_ton_pricing_product+'</td>'+
            '<td>Expected Shipping Total:</td>'+
            '<td>'+d.order_sheet_shipping+'</td>'+
        '</tr>'+
    '</table>';
}

$(document).on('click',".save-note",function(){
   var invoice_id = $(this).data("id");
   var value = $(".change_note_"+invoice_id).val();

   $.ajax({
        type: "POST",
        url: "assets/ajax/update_invoice.php",
        data:{
            "id"            : invoice_id,
            "review_note"   : value,
        },
        success:function(data)
        {
            if(data == "somthingWrong")
            {
                Swal.fire({
                    title:"Somthing Wrong",
                    text:"Please Try Again",
                    type:"warning",
                    confirmButtonText:"Ok"
                }).then( () => {
                    
                });                                
            }
        }
    });
}); 

var invoices = "";
var showMore = true;
function fetch_data(shipper,startDate,endDate,archive, threshold = null, compare = null)
{
     $("#invoices_table").dataTable().fnDestroy();
     var fillter_vendors = $(".fillter_vendors").val();
      invoices = $('#invoices_table').DataTable({
           "fixedHeader": true,
        //   "scrollX": true,
           "ordering": false,
           "retrieve": true,
           "pageLength": 100,
           "processing": true,
           "serverSide": true,
           "autoWidth": true,  
           "serverMethod": 'post',
           "ajax" :{
                "url": "assets/ajax/fetch_invoices.php",
                "data":{
                    shipper:shipper,
                    startDate:startDate,
                    endDate:endDate,
                    archive:archive,
                    threshold:threshold,
                    compare:compare,
                    fillter_vendors:fillter_vendors
                },
                "type":"POST",
                 complete: function (data) {
                     if(data["responseJSON"].invoices_not_exists_flag){
                         $(".div_to_show_ids").html(data["responseJSON"].invoices_not_exists);
                         $("#invoices_compare_not_exsits").modal("show");
                     }
                 },
            },
            'createdRow': function ( row, data, index ) {
                if (data["tracking"] == "" || data["tracking"] ==  null) {
                    $(row).addClass('highlight');
                }
            },        
           'columns' : [ 
                {
                    "className":      'dt-control',
                    "orderable":      false,
                    "data":           '',
                    "render": function ( data, type, full, meta ) {
                         var buttonID = full.id;
                         return '<span class="plus_btn_'+buttonID+'" data-id='+buttonID+'></span><i class="fa fa-plus-circle" aria-hidden="true"></i>';
                     }
                },
    
            	{data:'number'},
            	{data:'report_we'},
            	{data:'name'},
            	{data:'invoice_cost'},
            	{data:'order_total'},
            // 	{data:'new_ton_pricing_product'},
            	{data:'tracking'},
            	{data:'inv'},
            	{data:'shipper'},
            	{data:'vendor'},
            	{data:'on_report'},
            	{data:'matches_report'},
            	{data:'archive'},
            	{data:'edit'}
            ],
        });
        
setTimeout(function(){  $(".plus_btn_"+last_open_form).click();}, 1000);
        
        if(showMore){
            // Add event listener for opening and closing details
            $('#invoices_table tbody').on('click', 'td.dt-control', function () {
            
                var tr = $(this).closest('tr');
                var row = invoices.row( tr );
                console.log(row);
                console.log(row.child.isShown());
            
                if ( row.child.isShown() ) {
                    // This row is already open - close it
                    row.child.hide();
                    tr.removeClass('shown');
                }
                else {
                    row.child( format(row.data()) ).show();
                    tr.addClass('shown');
                }
            });
            showMore = false;
        }
}

    
function parseURLParams(url) {
    var queryStart = url.indexOf("?") + 1,
        queryEnd   = url.indexOf("#") + 1 || url.length + 1,
        query = url.slice(queryStart, queryEnd - 1),
        pairs = query.replace(/\+/g, " ").split("&"),
        parms = {}, i, n, v, nv;

    if (query === url || query === "") return;

    for (i = 0; i < pairs.length; i++) {
        nv = pairs[i].split("=", 2);
        n = decodeURIComponent(nv[0]);
        v = decodeURIComponent(nv[1]);

        if (!parms.hasOwnProperty(n)) parms[n] = [];
        parms[n].push(nv.length === 2 ? v : null);
    }
    return parms;
}