<?php
include 'connection.php';

?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Vendor Invoices</title>
    <link rel="stylesheet" href="assets/css/bootstrap.css">
    <link rel="stylesheet" href="assets/css/fontawesome.css">
    <link rel="stylesheet" href="assets/css/select2.min.css">
    <link rel="stylesheet" href="assets/css/dataTables.bootstrap4.min.css">
    <link rel="stylesheet" href="assets/css/main.css">
    <link rel="stylesheet" href="https://cdn.datatables.net/fixedheader/3.2.2/css/fixedHeader.bootstrap4.min.css">
    <!--<link rel="stylesheet" href="https://cdn.datatables.net/1.11.5/css/jquery.dataTables.min.css">-->
    
</head>
<body>
    
    <div class="container-fluid pr-5 pl-5 mt-5">
        <div class="row">
                <div class="col-md-4">
                    <h2 class="d-inline-block mb-0">Vendor Invoices</h2>                    
                    <button type="button" class="btn btn-primary" data-toggle="modal" data-target="#exampleModal">Add Invoice</button>                
                </div>
                <div class='col-5'>
                     <div class="d-inline-block w-50">
                        <div class="form-group mb-0">
                            <select id="fillter_shipper" name="fillter_shipper" class="form-control fillter_shipper" style="display:inline-block;background-color: black; color: silver">
                                <option value="">Select Shipper</option>
                                <option value="Central">Central</option>
                                <option value="CTL2">CTL2</option>
                                <option value="Dohrn">Dohrn</option>
                                <option value="Speedee">Speedee</option>
                                <option value="Magnum">Magnum</option>
                            </select>
                        </div>
                    </div>
                    
                    <div class="d-inline-block" style="width:49%;">
                        <div class="form-group">
                            <select id="fillter_vendors" name="fillter_vendors" class="form-control fillter_vendors" style="display:inline-block;background-color: black; color: silver">
                                <option value="">Select Vendor</option>
                                <?php 
                                    $selectSql = "SELECT * FROM bbqpo_vendors";
                                    $fetch = mysqli_query($connect,$selectSql);
                                    while($vendors = mysqli_fetch_assoc($fetch)) {
                                ?>
                                        <option value="<?= $vendors['value'] ?>" <?= (isset($_POST['fillter_vendors']) && $_POST['fillter_vendors'] == $vendors['value']) ? "selected" : '' ?>><?= $vendors['name'] ?></option>
                                <?php
                                    }
                                ?>
                                
                                <!--<option value="Diamond"  <?= (isset($_POST['fillter_vendors']) && $_POST['fillter_vendors'] == "Diamond") ? "selected" : '' ?>>Diamond</option>-->
                                <!--<option value="Simpson"  <?= (isset($_POST['fillter_vendors']) && $_POST['fillter_vendors'] == "Simpson") ? "selected" : '' ?>>Simpson</option>-->
                                <!--<option value="Riverside"  <?= (isset($_POST['fillter_vendors']) && $_POST['fillter_vendors'] == "Riverside") ? "selected" : '' ?>>Riverside</option>-->
                                <!--<option value="Treasures"  <?= (isset($_POST['fillter_vendors']) && $_POST['fillter_vendors'] == "Treasures") ? "selected" : '' ?>>Treasures</option>-->
                                <!--<option value="ManOWar"  <?= (isset($_POST['fillter_vendors']) && $_POST['fillter_vendors'] == "ManOWar") ? "selected" : '' ?>>ManOWar</option>-->
                                <!--<option value="Janie's"  <?= (isset($_POST['fillter_vendors']) && $_POST['fillter_vendors'] == "Janie's") ? "selected" : '' ?>>Janie's</option>-->
                                <!--<option value="LJ"  <?= (isset($_POST['fillter_vendors']) && $_POST['fillter_vendors'] == "LJ") ? "selected" : '' ?>>LJ</option>-->
                                <!--<option value="Coir Mart"  <?= (isset($_POST['fillter_vendors']) && $_POST['fillter_vendors'] == "Coir Mart") ? "selected" : '' ?>>Coir Mart</option>-->
                                <!--<option value="HFI Watertown"  <?= (isset($_POST['fillter_vendors']) && $_POST['fillter_vendors'] == "HFI Watertown") ? "selected" : '' ?>>HFI Watertown</option>-->
                                <!--<option value="Keystone"  <?= (isset($_POST['fillter_vendors']) && $_POST['fillter_vendors'] == "Keystone") ? "selected" : '' ?>>Keystone</option>-->
                                <!--<option value="Bag Buddy"  <?= (isset($_POST['fillter_vendors']) && $_POST['fillter_vendors'] == "Bag Buddy") ? "selected" : '' ?>>Bag Buddy</option>-->
                                <!--<option value="New Country"  <?= (isset($_POST['fillter_vendors']) && $_POST['fillter_vendors'] == "New Country") ? "selected" : '' ?>>New Country</option>-->
                                <!--<option value="Unicorn"  <?= (isset($_POST['fillter_vendors']) && $_POST['fillter_vendors'] == "Unicorn") ? "selected" : '' ?>>Unicorn</option>-->
                                <!--<option value="Presto"  <?= (isset($_POST['fillter_vendors']) && $_POST['fillter_vendors'] == "Presto") ? "selected" : '' ?>>Presto</option>-->
                                <!--<option value="Faithway"  <?= (isset($_POST['fillter_vendors']) && $_POST['fillter_vendors'] == "Faithway") ? "selected" : '' ?>>Faithway</option>-->
                                <!--<option value="D and R Feed"  <?= (isset($_POST['fillter_vendors']) && $_POST['fillter_vendors'] == "D and R Feed") ? "selected" : '' ?>>D and R Feed</option>-->
                                <!--<option value="Mast"  <?= (isset($_POST['fillter_vendors']) && $_POST['fillter_vendors'] == "Mast") ? "selected" : '' ?>>Mast</option>-->
                                <!--<option value="LJ Oak Mush"  <?= (isset($_POST['fillter_vendors']) && $_POST['fillter_vendors'] == "LJ Oak Mush") ? "selected" : '' ?>>LJ Oak Mush</option>                            -->
                            </select>
                        </div>
                    </div>
                </div>
                <div class="col-md-3 d-flex align-items-center">
                    Threshold: <input type="text" id="Threshold" class="form-control ml-1" placeholder="Threshold" value="10"> <button class="btn btn-primary ml-1" id="check_diff" style="height:fit-content">Check</button>
                </div>
        </div>
            <div class="row justify-content-center">
                 
            <div class="col-md-3">
                <button class="btn btn-danger mr-2" data-toggle="modal" data-target="#invoices_comparion">Invoice Comparison Input</button>
                <div class="form-check mt-2 d-inline-block">
                  <input class="form-check-input" type="checkbox" value="1" id="archive_flag" name="archive_flag" <?= (isset($_POST['archive']) && $_POST['archive'] == 1) ? "checked" : '' ?>>
                  <label class="form-check-label" for="archive_flag">
                    Archive
                  </label>
                </div>            
            </div>
             <div class="col-9 d-flex flex-wrap mt-3">
                <div class="form-group d-flex align-items-center col-3 mb-0">
                    <label class="mb-0 mx-2" style="white-space:nowrap;">Start Date</label>
                    <input type="date" name="startDate" id="startDate" class="form-control"  value="<?= (isset($_POST['startDate'])) ?  $_POST['startDate']  : '' ?>">
                </div>
                <div class="form-group d-flex align-items-center col-3 mb-0">
                    <label class="mb-0 mx-2" style="white-space: nowrap;">End Date</label>
                    <input type="date" name="endDate" id="endDate" class="form-control" value="<?= (isset($_POST['endDate'])) ?  $_POST['endDate']  : '' ?>">
                </div>
                <div class="form-group d-flex align-items-center col-3 mb-0">
                    <button class="btn btn-primary btn-search-date">Search <i class="fas fa-search"></i></button>
                </div>
            </div>
            
            <div class='col-12 mt-3'>
                <div class="table-responsive">
                    <table id="invoices_table" class='trace-table table table-bordered table-light'>
                        <thead>
                            <th></th>
                            <th class='text-center'>#</th>
                            <th>Date of <br>invoice</th>
                            <th>Name</th>
                            <th>Inv Cost Total</th>
                            <!--<th>Inv product</th>-->
                            <!--<th>Inv<br>Freight</th>-->
                            <th>Expected Total</th>
                            <!--<th>Expected product</th>-->
                            <!--<th>Expected Freight</th>-->
                            <th>Tracking</th>
                            <th>Inv</th>
                            <th>Shipper</th>
                            <th>Vendor</th>
                            <!--<th>Review notes</th>-->
                            <th>On Report</th>
                            <th>Matches<br>Report</th>
                            <th>Archive</th>
                            <th>Edit</th>
                        </thead>
                    </table>
                </div>
            </div>
        </div>
    </div>

    <script src="assets/js/jquery-3.5.1.min.js"></script>
    <script src="assets/js/popper.min.js"></script>
    <script src="assets/js/bootstrap.js"></script>
    <script src="assets/js/fontawesome.js"></script>
    <script src="assets/js/sweetalert2.all.min.js"></script>
    <script src="assets/js/jquery.dataTables.min.js"></script>
    <script src="assets/js/select2.min.js"></script>
    <script src="assets/js/dataTables.bootstrap4.min.js"></script>
    <script src="assets/js/main.js"></script>
    <script src="https://cdn.datatables.net/fixedheader/3.2.2/js/dataTables.fixedHeader.min.js"></script>
    
 <!-- Modal -->
  <div class="modal fade" id="NewInvoice" role="dialog">
    <div class="modal-dialog modal-lg" style="width: 1200px;max-width:1200px;">
    
      <!-- Modal content-->
      <div class="modal-content">
        <div class="modal-header">
          <h4 class="modal-title invoice-number">Invoice # <span></span></h4>
          <button type="button" class="close" data-dismiss="modal">&times;</button>
        </div>
        <div class="modal-body">
          <iframe style="width:100%;height:70vh" src=""></iframe>
        </div>
        <div class="modal-footer">
          <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
        </div>
      </div>
      
    </div>
  </div>   
  
  
<!-- Modal -->
<div class="modal fade" id="invoices_comparion" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
  <div class="modal-dialog">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title" id="exampleModalLabel">Invoice Comparison</h5>
        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
          <span aria-hidden="true">&times;</span>
        </button>
      </div>
      <div class="modal-body">
        <textarea class="form-control" id="invoices_comparion_input" rows="4"></textarea>
      </div>
      <div class="modal-footer">
        <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
        <button type="button" class="btn btn-primary btn-compare-invoices">Save changes</button>
      </div>
    </div>
  </div>
</div>

  
<!-- Modal -->
<div class="modal fade" id="invoices_compare_not_exsits" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
  <div class="modal-dialog">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title" id="exampleModalLabel">Invoices not exists</h5>
        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
          <span aria-hidden="true">&times;</span>
        </button>
      </div>
      <div class="modal-body">
        <h3 class="div_to_show_ids"></h3>
      </div>
      <div class="modal-footer">
        <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
      </div>
    </div>
  </div>
</div>  


 <!-- Modal -->
<div class="modal fade" id="exampleModal" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
  <div class="modal-dialog">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title" id="exampleModalLabel">Add new Invoice</h5>
        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
          <span aria-hidden="true">&times;</span>
        </button>
      </div>
      <div class="modal-body">
        <form action="" method="POST" id="add-order">
            <div class="form-row">
                <div class="col-md-6">
                    <label>Date of invoice</label>
                    <input type="date" class="form-control" name="report_we" value="<?= isset($_GET['date_of_invoice']) ? $_GET['date_of_invoice'] : '' ?>">
                </div>
                <div class="col-md-6">
                    <label>Name</label>
                    <input type="text" class="form-control" name="name" value="<?= isset($_GET['name']) ? $_GET['name']: '' ?>">
                </div>
            </div>  
            <div class="form-row mt-2">
                <div class="col-md-6">
                    <label>Tracking</label>
                    <input type="text" class="form-control" name="tracking" value="<?= isset($_GET['tracking'])? $_GET['tracking'] : '' ?>">
                </div>
                <div class="col-md-6">
                    <label>Shipper</label>
                    <select class="form-control custom-select" name="shipper">
                        <option value="Central" <?= (isset($_GET['shipper']) && $_GET['shipper'] == 'Central') ? 'selected': '' ?>>Central</option>
                        <option value="CTL2" <?= (isset($_GET['shipper']) && $_GET['shipper'] == 'CTL2') ? 'selected': '' ?>>CTL2</option>
                        <option value="Dohrn" <?= (isset($_GET['shipper']) && $_GET['shipper'] == 'Dohrn') ? 'selected': '' ?>>Dohrn</option>
                        <option value="Magnum" <?= (isset($_GET['shipper']) && $_GET['shipper'] == 'Magnum') ? 'selected': '' ?>>Magnum</option>
                        <option value="Road Runner" <?= (isset($_GET['shipper']) && $_GET['shipper'] == 'Road Runner') ? 'selected': '' ?>>Road Runner</option>
                        <option value="Speedee" <?= (isset($_GET['shipper']) && $_GET['shipper'] == 'Speedee') ? 'selected': '' ?>>Speedee</option>
                    </select>
                </div>
            </div> 
            
            <div class="form-row mt-2">
                <div class="col-md-6">
                    <label>Vendor</label>
                    <select class="form-control custom-select" name="vendor">
                        <option value=""></option>
                        <option value="Diamond" <?= (isset($_GET['vendor']) && $_GET['vendor'] == 'Diamond') ? 'selected': '' ?>>Diamond</option>
                        <option value="Simpson" <?= (isset($_GET['vendor']) && $_GET['vendor'] == 'Simpson') ? 'selected': '' ?>>Simpson</option>
                        <option value="Riverside" <?= (isset($_GET['vendor']) && $_GET['vendor'] == 'Riverside') ? 'selected': '' ?>>Riverside</option>
                        <option value="Treasures" <?= (isset($_GET['vendor']) && $_GET['vendor'] == 'Treasures') ? 'selected': '' ?>>Treasures</option>
                        <option value="ManOWar" <?= (isset($_GET['vendor']) && $_GET['vendor'] == 'ManOWar') ? 'selected': '' ?>>ManOWar</option>
                        <option value="Janie's" <?= (isset($_GET['vendor']) && $_GET['vendor'] == "Janie's") ? 'selected': '' ?>>Janie's</option>
                        <option value="LJ" <?= (isset($_GET['vendor']) && $_GET['vendor'] == 'LJ') ? 'selected': '' ?>>LJ</option>
                        <option value="Coir Mart" <?= (isset($_GET['vendor']) && $_GET['vendor'] == 'Coir Mart') ? 'selected': '' ?>>Coir Mart</option>
                        <option value="HFI Watertown" <?= (isset($_GET['vendor']) && $_GET['vendor'] == 'HFI Watertown') ? 'selected': '' ?>>HFI Watertown</option>
                        <option value="Keystone" <?= (isset($_GET['vendor']) && $_GET['vendor'] == 'Keystone') ? 'selected': '' ?>>Keystone</option>
                        <option value="Bag Buddy" <?= (isset($_GET['vendor']) && $_GET['vendor'] == 'Bag Buddy') ? 'selected': '' ?>>Bag Buddy</option>
                        <option value="New Country" <?= (isset($_GET['vendor']) && $_GET['vendor'] == 'New Country') ? 'selected': '' ?>>New Country</option>
                        <option value="Unicorn" <?= (isset($_GET['vendor']) && $_GET['vendor'] == 'Unicorn') ? 'selected': '' ?>>Unicorn</option>
                        <option value="Presto" <?= (isset($_GET['vendor']) && $_GET['vendor'] == 'Presto') ? 'selected': '' ?>>Presto</option>
                        <option value="Faithway" <?= (isset($_GET['vendor']) && $_GET['vendor'] == 'Faithway') ? 'selected': '' ?>>Faithway</option>
                        <option value="D and R Feed" <?= (isset($_GET['vendor']) && $_GET['vendor'] == 'D and R Feed') ? 'selected': '' ?>>D and R Feed</option>
                        <option value="Mast" <?= (isset($_GET['vendor']) && $_GET['vendor'] == 'Mast') ? 'selected': '' ?>>Mast</option>
                        <option value="Other" <?= (isset($_GET['vendor']) && $_GET['vendor'] == 'Other') ? 'selected': '' ?>>Other</option>
                    </select>
                </div>
                
                <div class="col-md-6">
                    <label>Inv</label>
                    <input type="text" class="form-control" name="inv">
                </div>
            </div>
            <div class="form-row mt-2">
                <div class="col-md-6">
                    <label>Inv Cost Total</label>
                    <input type="text" class="form-control" name="invoice_cost">
                </div>
                
                <div class="col-md-6">
                    <label>Expected Total</label>
                    <input type="text" class="form-control" name="order_total" value="<?= isset($_GET['totalcost']) ? $_GET['totalcost'] : '' ?>">
                </div>
            </div>
             <div class="form-row mt-2">
                <div class="col-md-6">
                    <label>Inv Product Total</label>
                    <input type="text" class="form-control" name="invoice_product_total">
                </div>
                
                <div class="col-md-6">
                    <label>Expected Product Total</label>
                    <input type="text" class="form-control" name="new_ton_pricing_product" value="<?= isset($_GET['pelletcost']) ? $_GET['pelletcost'] : '' ?>">
                </div>
            </div>
             <div class="form-row mt-2">
                <div class="col-md-6">
                    <label>Inv Shipping Total</label>
                    <input type="text" class="form-control" name="invoice_freight">
                </div>
                
                <div class="col-md-6">
                    <label>Expected Shipping Total</label>
                    <input type="text" class="form-control" name="order_sheet_shipping" value="<?= isset($_GET['shippingprice']) ? $_GET['shippingprice'] : '' ?>">
                </div>
            </div>
            
        </form>
      </div>
      <div class="modal-footer">
        <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
        <button type="button" class="btn btn-primary btn-add-order">Add</button>
      </div>
    </div>
  </div>
</div>
  
  <!-- Modal -->
<div class="modal fade" id="edit-modal" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
  <div class="modal-dialog">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title" id="exampleModalLabel">Edit</h5>
        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
          <span aria-hidden="true">&times;</span>
        </button>
      </div>
      <div class="modal-body">
        <div class="form-row">
            <input type="hidden" id="invoice_id">
            <div class="col-6">
                <label for="tracking_number">Tracking number</label>
                <input type"text" class="form-control" name="tracking_number" id="tracking_number" value="">
            </div>
            <div class="col-6">
                <label for="shipper">Shipper</label>
                <select class="form-control" name="shipper" id="shipper">
                    <option value="Central">Central</option>
                    <option value="Speedee">Speedee</option>
                    <option value="Dohrn">Dohrn</option>
                    <option value="CTL2">CTL2</option>
                    <option value="Magnum">Magnum</option>
                </select>
            </div>            
        </div>
         <div class="form-row mt-2">
            <div class="col-md-6">
                <label>Inv Cost Total</label>
                <input type="text" class="form-control" name="edit_invoice_cost" id="edit_invoice_cost">
            </div>
            
            <div class="col-md-6">
                <label>Expected Total</label>
                <input type="text" class="form-control" name="edit_order_total" id="edit_order_total" value="">
            </div>
        </div>
         <div class="form-row mt-2">
            <div class="col-md-6">
                <label>Inv Product Total</label>
                <input type="text" class="form-control" name="edit_invoice_product_total" id="edit_invoice_product_total">
            </div>
            
            <div class="col-md-6">
                <label>Expected Product Total</label>
                <input type="text" class="form-control" name="edit_new_ton_pricing_product" id="edit_new_ton_pricing_product" value="">
            </div>
        </div>
         <div class="form-row mt-2">
            <div class="col-md-6">
                <label>Inv Shipping Total</label>
                <input type="text" class="form-control" name="edit_invoice_freight" id="edit_invoice_freight">
            </div>
            
            <div class="col-md-6">
                <label>Expected Shipping Total</label>
                <input type="text" class="form-control" name="edit_order_sheet_shipping" id="edit_order_sheet_shipping" value="">
            </div>
        </div>        
      </div>
      <div class="modal-footer">
        <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
        <button type="button" class="btn btn-primary save_edit_invoice">Save changes</button>
      </div>
    </div>
  </div>
</div>
<script>
    var url_string = window.location;
    var url = new URL(url_string);
    var flag = url.searchParams.get("flag");

    if(flag == 1) {
        $(document).ready(function() {
            $('#exampleModal').modal('show'); 
        });
    }
</script>
  
</body>
</html>